<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

// Import all controllers
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\CasesController;
use App\Http\Controllers\TestController;
use App\Http\Controllers\TestTypesController;
use App\Http\Controllers\ColController;
use App\Http\Controllers\ColRowController;
use App\Http\Controllers\DoorOpenTypeController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\BillController;
use App\Http\Controllers\BillReportTypeController;
use App\Http\Controllers\QuotationController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\CasesImageController;
use App\Http\Controllers\UserFileController;
use App\Http\Controllers\SensorController;
use App\Http\Controllers\ACDetailController;
use App\Http\Controllers\CustomerDocumentController;
use App\Http\Controllers\PageDetailController;
use App\Http\Controllers\DataLoggerTwoController;
use App\Http\Controllers\DataLoggerController;

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});


// ---------- Public APIs ----------
Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']);
Route::post('/customerregister', [AuthController::class, 'registerCustomer']);
Route::post('/customerlogin', [AuthController::class, 'loginCustomer']);
Route::post('/forget-password', [AuthController::class, 'forgetPassword']);
Route::post('/update-password', [AuthController::class, 'updatePassword']);

Route::get('/test', function () {
    return response()->json(['message' => 'This is a test message']);
});
//  Route::post('data-loggers-upload', [DataLoggerController::class, 'uploadSheet']);


// ---------- Protected APIs ----------
Route::middleware(['auth:sanctum'])->group(function () {

    Route::post('/logout', [AuthController::class, 'logout']);

    Route::apiResources([
        'users' => UserController::class,
        'companies' => CompanyController::class,
        'customers' => CustomerController::class,
        'cases' => CasesController::class,
        'tests' => TestController::class,
        'testtypes' => TestTypesController::class,
        'cols' => ColController::class,
        'colrows' => ColRowController::class,
        'dooropentype' => DoorOpenTypeController::class,
        'files' => FileController::class,
        'bills' => BillController::class,
        'billreporttypes' => BillReportTypeController::class,
        'quotations' => QuotationController::class,
        'invoices' => InvoiceController::class,
        'cases-images' => CasesImageController::class,
        'users-files' => UserFileController::class,
        'sensors' => SensorController::class,
        'ac-details' => ACDetailController::class,
        'customer-documents' => CustomerDocumentController::class,
        'page-details' => PageDetailController::class,
        'data-logger-two' => DataLoggerTwoController::class,
    ]);

    // Custom routes
    Route::get('case-sensors/{id}', [CasesController::class, 'getSensor']);
    Route::get('stats', [CasesController::class, 'stats']);
    Route::get('dailycase', [CasesController::class, 'dailycase']);
    Route::post('passCase', [CasesController::class, 'passCase']);
    Route::get('getTemp/{id}/{testTypeId}', [TestController::class, 'getTemp']);
    Route::get('getHumidity/{id}/{testTypeId}', [TestController::class, 'getHumidityTemp']);
    Route::post('import', [TestController::class, 'import2']);
    Route::post('test-delete-all', [TestController::class, 'massDeleteAll']);
    Route::get('fetch-raw-data/{caseId}', [TestController::class, 'fetchRawData']);
    Route::put('test-update-all/{testTypeId}', [TestController::class, 'massUpdateAll']);
    Route::put('test-replicate-all/{testTypeId}', [TestController::class, 'replicateUpdateAll']);
    Route::get('data-loggers/{cases}', [DataLoggerController::class, 'show']);
    Route::post('data-loggers-upload', [DataLoggerController::class, 'uploadSheet']);
    Route::put('fetch-raw-data/{caseId}', [TestController::class, 'getRawDataWithFilter']);
    Route::post('sensors-upload', [SensorController::class, 'import']);
});


// ---------- Utility Routes ----------
Route::get('/clear', function () {
    Artisan::call('config:cache');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('config:clear');
    return "Application caches cleared!";
});

Route::post('import2', [TestController::class, 'import2']);
