<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Test extends Model
{
    protected $fillable = [
        'case_id',
        'test_type_id',
        'date',
        'time',
        'temp',
        'sensor',
        'filter_datetime','humidity'
    ];

    public function cases()
    {
        return $this->belongsTo('App\Cases', 'case_id', 'id');
    }

    public function testType()
    {
        return $this->belongsTo('App\TestTypes', 'test_type_id', 'id');
    }
}
