<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Quotation extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'company_id',
        'customer_id',
        'user_id',
        'quotation_type',
        'quotation_no',
        'quotation_date',
        'quotation_valid_till',
        'gstin',
        'date',
        'net_amount',
        'cgst',
        'gst',
        'total_tax_amount',
        'total_order_amount',
        'is_approved',
        'gst_type'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    public function quotation_details()
    {
        return $this->hasMany(QuotationDetail::class);
    }
}
