<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'company_id',
        'customer_id',
        'user_id',
        'invoice_type',
        'invoice_no',
        'quotation_ref',
        'purchase_order_no',
        'purchase_order_date',
        'invoice_gstin',
        'invoice_challan',
        'date',
        'net_amount',
        'cgst',
        'gst',
        'total_tax_amount',
        'total_order_amount',
        'is_paid',
        'gst_type',
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }
    public function invoice_details()
    {
        return $this->hasMany(InvoiceDetail::class);
    }
}
