<?php

namespace App\Imports;

use App\Test;
use Illuminate\Contracts\Queue\ShouldQueue;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\SkipsErrors;
use Maatwebsite\Excel\Concerns\SkipsFailures;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithBatchInserts;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Carbon\Carbon;

class TestsImport implements ToModel, WithHeadingRow, WithValidation, WithChunkReading, WithBatchInserts, ShouldQueue
{
    use Importable, SkipsFailures;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        Test::where('case_id', $row['case_id'])->where('test_type_id', $row['test_type_id'])->delete();
        return new Test([
            'case_id' => $row['case_id'],
            'test_type_id' => $row['test_type_id'],
            'date' => $row['date'],
            // 'time' => Carbon::instance(\PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($row['time'])),
            'time' => $row['time'],
            'temp' => $row['temp'],
            'sensor' => $row['sensor'],
            'filter_datetime' => Carbon::parse($row['date'] . $row['time'])->format('Y-m-d H:m:s'),
        ]);
    }

    public function rules(): array
    {
        return [
            '*.case_id' => 'required',
            '*.test_type_id' => 'required',
            '*.date' => 'required',
            '*.time' => 'required',
            '*.temp' => 'required',
            '*.sensor' => 'required',
        ];
    }

    public function batchSize(): int
    {
        return 1000;
    }

    public function chunkSize(): int
    {
        return 1000;
    }
}
