<?php

namespace App\Http\Controllers;

use App\UserFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class UserFileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $vaildator = Validator::make($request->all(), [
            'file' => 'required',
            'user_id' => 'required'
        ]);

        if ($vaildator->fails()) return \response(['errors' => $vaildator->errors()->getMessages()], 422);

        if ($request->has('id')) {
            if ($request->hasFile('file')) {
                $fileNameWithExt = $request->file('file')->getClientOriginalName();
                $request->file('file')->move(\storage_path('app/public/User-Files/'), $fileNameWithExt);
                $ci = UserFile::find($request->id);
                $ci->fill($request->all());
                $ci->file = $fileNameWithExt;
                $ci->save();
                return $ci;
            }
        }

        if ($request->hasFile('file')) {
            $fileNameWithExt = $request->file('file')->getClientOriginalName();
            $request->file('file')->move(\storage_path('app/public/User-Files/'), $fileNameWithExt);
            $ci = new UserFile();
            $ci->fill($request->all());
            $ci->file = $fileNameWithExt;
            $ci->save();
        }

        return $ci;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $vaildator = Validator::make($request->all(), [
            'file' => 'required',
            'user_id' => 'required'
        ]);

        if ($vaildator->fails()) return \response(['errors' => $vaildator->errors()->getMessages()], 422);

        if ($request->hasFile('file')) {
            $fileNameWithExt = $request->file('file')->getClientOriginalName();
            $ci = UserFile::find($id);
            $ci->fill($request->all());
            $ci->file = $fileNameWithExt;
            $ci->save();
        }

        return $ci;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        UserFile::find($id)->delete();
    }
}
