<?php

namespace App\Http\Controllers;

use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return User::with('files')->get();
    }


    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
              'name'=>'required', 'email'=>'required', 'password'=>'required', 'role'=>'required', 'type', 'emp_id', 'is_active', 'phone'=>'required', 'gst_no', 'pan_no', 'location', 'pincode'

        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        $user= User::create($request->all());
        $user->password=Hash::make($request->password);
        $user->save();
        return $user;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\User  $User
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return User::find($id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\User  $User
     * @return \Illuminate\Http\Response
     */
    public function edit(User $User)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\User  $User
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
             'name'=>'required', 'email'=>'required', 'role'=>'required', 'type', 'emp_id', 'is_active', 'phone'=>'required', 'gst_no', 'pan_no','location', 'pincode'
        ]);
        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }
        User::find($id)->update($request->all());
        $user=User::find($id);
        $user->password=Hash::make($request->password);
        $user->save();
        return $user;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\User  $User
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return User::find($id)->delete();
    }
}
