<?php

namespace App\Http\Controllers;

use App\TestTypes;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TestTypesController extends Controller
{
    public function index()
    {
        return TestTypes::get();
    }


    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
            'case_id',
            'test_type_id',
            'date',
            'time',
            'temp',
            'sensor',

        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        return TestTypes::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return TestTypes::where('id', $id)->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
            'case_id',
            'test_type_id',
            'date',
            'time',
            'temp',
            'sensor',
        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }
        return TestTypes::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return TestTypes::find($id)->delete();
    }
}
