<?php

namespace App\Http\Controllers;

use App\Imports\TestsImport;
use App\Test;
use App\Cases;
use App\TestTypes;
use Carbon\Carbon;
use DateTime;
use DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\Validator;
use Rap2hpoutre\FastExcel\FastExcel;

class TestController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Test::with('cases', 'testType')->get();
    }

    public function import(Request $request)
    {
        $file = $request->file('file');
        $import = (new TestsImport)->import($file);
        // return $import;
        if ($import) {
            return response('success');
        } else {
            return response('failure');
        }
    }

    public function import2(Request $request)
    {
        // to extract sensor name
        $fileName = $request->file('file')->getClientOriginalName();
        $words = \explode('.', $fileName);

        $file = $request->file('file');

        $import = (new FastExcel)->import($file, function ($line) use ($request, $words) {

            // Test::create([
            //     'case_id' => $request->case_id,
            //     'test_type_id' => \null,
            //     'date' => $line['date'],
            //     'time' => $line['time'],
            //     'temp' => $line['temp'],
            //     'sensor' => $words[0],
            //     'filter_datetime' => DateTime::createFromFormat('Y-m-d H:m:s', strtotime($line['date'] . $line['time'])),
            // ]);

            $test = new Test();
            $test->case_id = $request->case_id;
            $test->test_type_id = null;
            $test->date = Carbon::parse($line['date'])->format('Y-m-d');
            // $test->time = Carbon::parse($line['time'])->format('H:m:s');
            $test->time = Carbon::parse($line['time'])->format('H:i:s');
            $test->temp = $line['temp'];
            $test->humidity = $line['humidity'];
            $test->sensor = $words[0];
            $test->filter_datetime = Carbon::parse(($test->date . $test->time))->format('Y-m-d H:i:s');
            $test->save();
        });
        // return $import;
        if ($import) {
            return response('success');
        } else {
            return response('failure');
        }
    }


    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
            'case_id',
            'test_type_id',
            'date',
            'time',
            'temp',
            'sensor',

        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        return Test::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {

            // $tests= Test::where('case_id',$id)->groupBy('sensor')->get();
            if (Test::where('case_id', $id)) {
                $sensors = Test::where('case_id', $id)->distinct('sensor')->pluck('sensor');
                foreach ($sensors as $sensor) {
                    $y = (object)['sensor' => $sensor, 'data' => Test::where('case_id', $id)->where('sensor', $sensor)->with('testType')->get()];
                    $datas[] = $y;
                }

                if ($datas == 'Undefined')
                    return response(['error' => "not found"], 404);
                else
                    return $datas;
            }
        } catch (\Exception $e) {
            // \DB::rollback();
            return response()->json(['error' => "not found"], 404);
        }
    }

    public function getHumidityTemp($id, $testTypeId)
    {
        $tests = Test::where('case_id', $id)->orderBy('sensor')->get();
        $sensors = Test::where('case_id', $id)->distinct('sensor')->pluck('sensor');
        $marks = [];
        foreach ($sensors as $sensor) {
            // return $sensor;
            $pmin = 10000;
            $pmax = -999.99;
            $psens = 0;
            $pcount = 0;
            // $Testcount = 0;
            $TestSum = 0.0;
            $testSquareSum = 0.0;
            $variance = 0.0;
            $numerator = 0.0;
            $sd = 0.0;
            $testCount = Test::where('case_id', $id)->where('sensor', $sensor)->count();
            $arr = [];
            foreach ($tests as $test) {




                // if (isset($test->testType) && \strchr($test->testType->name, 'CONTINUOUS OPERATION')) {
                if (isset($test->testType) && $test->testType->id == $testTypeId) {
                    // if (strchr($test->sensor, 'AMB')) continue;
                    // if ($test->sensor == $sensor) {
                    //     $pmin = min($pmin, (float)$test->temp + 100);
                    //     $pmax = max($pmax, (float)$test->temp + 100);
                    //     $psens += (float)$test->temp;
                    //     $pcount++;
                    //     $TestSum += $test->temp;
                    //     // $Testcount += 1;
                    // }

                    // if ($TestSum > 0) {
                    //     // $mean = $TestSum / count($tests); try 1
                    //     // $mean = $TestSum / $Testcount; try 2
                    //     $mean = $TestSum / $testCount; //try 3
                    //     $standardDeviation += pow(($test->temp - $mean), 2);
                    // }


                    if ($test->sensor == $sensor) {
                        $pmin = min($pmin, (float)$test->humidity + 100);
                        $pmax = max($pmax, (float)$test->humidity + 100);
                        $psens += (float)$test->humidity;
                        $arr[$pcount] = $test->humidity;
                        $pcount++;
                    }
                }
            }
            if ($pcount == 0) continue;
            else {
                $avg = round($psens / $pcount, 2);

                for ($i = 0; $i < $pcount; $i++) {
                    $numerator += pow(($arr[$i] - $avg), 2);
                }
                $denominator = $testCount - 1;
                $sd = sqrt($numerator / $denominator);


                $y = (object)['sensor' => $sensor, "min" => round($pmin - 100, 2), "max" => round($pmax - 100, 2), 'avg' => $avg, 'std' => round($sd, 2), 'avg2' => $avg];
                $marks[] = $y;
            }
        }
        return $marks;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */
    // public function getTemp($id, $testTypeId)
    // {
    //     $testType = TestTypes::find($testTypeId);
    //     if (isset($testType) && strchr($testType->name, 'HUMIDITY')) {
    //         return  $this->getHumidityTemp($id, $testTypeId);
    //     }

    //     $tests = Test::where('case_id', $id)->orderBy('sensor')->get();
    //     $sensors = Test::where('case_id', $id)->distinct('sensor')->pluck('sensor');

    //     // $c = Cases::where('id', $id)->where('type_of_room', 'Reefer Vehicle')->first();
    //     // if ($c) {
    //     //     // return $c->test_types;
    //     //     $nmarks = [];
    //     //     $marks = [];
    //     //     foreach ($sensors as $sensor) {
    //     //         $pmin = 10000;
    //     //         $pmax = -999.99;
    //     //         $psens = 0;
    //     //         $pcount = 0;
    //     //         $nmin = 10000;
    //     //         $nmax = -999.99;
    //     //         $nsens = 0;
    //     //         $ncount = 0;
    //     //         $Testcount = 0;
    //     //         $TestSum = 0;
    //     //         $testSquareSum = 0;
    //     //         $variance = 0;
    //     //         foreach ($tests as $test) {
    //     //             // if (isset($test->testType) && \strchr($test->testType->name, 'CONTINUOUS OPERATION')) { //old logic
    //     //             if (isset($test->testType) && $test->testType->id == $testTypeId) {

    //     //                 // if(strchr($test->sensor,'AMB')) continue;

    //     //                 if ($test->sensor == $sensor) {
    //     //                     if ((float)$test->temp > 0) {
    //     //                         $pmin = min($pmin, (float)$test->temp + 100);
    //     //                         // $pmax = (float)$test->temp + 100;
    //     //                         $pmax = max($pmax, (float)$test->temp + 100);
    //     //                         $psens += (float)$test->temp;
    //     //                         $pcount++;
    //     //                         $TestSum += $test->temp;
    //     //                         $Testcount += 1;
    //     //                     } else {
    //     //                         $nmin = min($nmin, (float)$test->temp + 100);
    //     //                         $nmax = max($nmax, (float)$test->temp + 100);
    //     //                         $nsens += (float)$test->temp;
    //     //                         $ncount++;
    //     //                         $TestSum += $test->temp;
    //     //                         $Testcount += 1;
    //     //                     }

    //     //                     if ($TestSum > 0 && $Testcount > 0) {
    //     //                         $testAvg = $TestSum / $Testcount;
    //     //                         $testSquareSum += pow(($testAvg - $test->temp), 2);
    //     //                         $variance = $testSquareSum / $testAvg;
    //     //                     }
    //     //                 }
    //     //             }
    //     //         }
    //     //         if ($pcount == 0) continue;
    //     //         else {
    //     //             $y = (object)['sensor' => $sensor, "min" => $pmin - 100, "max" => $pmax - 100, 'avg' => $psens / $pcount, 'std' => sqrt($variance)];
    //     //             $marks[] = $y;
    //     //         }

    //     //         if ($ncount == 0) continue;
    //     //         else {
    //     //             $x = (object)['sensor' => $sensor, "min" => $nmin - 100, "max" => $nmax - 100, 'avg' => $nsens / $ncount, 'std' => sqrt($variance)];
    //     //             $nmarks[] = $x;
    //     //         }
    //     //     }
    //     //     // return response(['pos' => $marks, 'neg' => $nmarks], 200);
    //     // }


    //     // check starts here
    //     $marks = [];
    //     foreach ($sensors as $sensor) {
    //         // return $sensor;
    //         $pmin = 10000;
    //         $pmax = -999.99;
    //         $psens = 0;
    //         $pcount = 0;
    //         // $Testcount = 0;
    //         $TestSum = 0.0;
    //         $testSquareSum = 0.0;
    //         $variance = 0.0;
    //         $numerator = 0.0;
    //         $sd = 0.0;
    //         $testCount = Test::where('case_id', $id)->where('sensor', $sensor)->count();
    //         $arr = [];
    //         foreach ($tests as $test) {




    //             // if (isset($test->testType) && \strchr($test->testType->name, 'CONTINUOUS OPERATION')) {
    //             if (isset($test->testType) && $test->testType->id == $testTypeId) {
    //                 // if (strchr($test->sensor, 'AMB')) continue;
    //                 // if ($test->sensor == $sensor) {
    //                 //     $pmin = min($pmin, (float)$test->temp + 100);
    //                 //     $pmax = max($pmax, (float)$test->temp + 100);
    //                 //     $psens += (float)$test->temp;
    //                 //     $pcount++;
    //                 //     $TestSum += $test->temp;
    //                 //     // $Testcount += 1;
    //                 // }

    //                 // if ($TestSum > 0) {
    //                 //     // $mean = $TestSum / count($tests); try 1
    //                 //     // $mean = $TestSum / $Testcount; try 2
    //                 //     $mean = $TestSum / $testCount; //try 3
    //                 //     $standardDeviation += pow(($test->temp - $mean), 2);
    //                 // }


    //                 if ($test->sensor == $sensor) {
    //                     $pmin = min($pmin, (float)$test->temp + 100);
    //                     $pmax = max($pmax, (float)$test->temp + 100);
    //                     $psens += (float)$test->temp;
    //                     $arr[$pcount] = $test->temp;
    //                     $pcount++;
    //                 }
    //             }
    //         }
    //         if ($pcount == 0) continue;
    //         else {
    //             $avg = round($psens / $pcount, 2);

    //             for ($i = 0; $i < $pcount; $i++) {
    //                 $numerator += pow(($arr[$i] - $avg), 2);
    //             }
    //             $denominator = $testCount - 1;
    //             $sd = sqrt($numerator / $denominator);


    //             $y = (object)['sensor' => $sensor, "min" => round($pmin - 100, 2), "max" => round($pmax - 100, 2), 'avg' => $avg, 'std' => round($sd, 2), 'avg2' => $avg];
    //             $marks[] = $y;
    //         }
    //     }
    //     return $marks;
    // }


  		public function getTemp($id, $testTypeId){
         	$testType = TestTypes::find($testTypeId);

if (isset($testType) && strchr($testType->name, 'HUMIDITY')) {
    return $this->getHumidityTemp($id, $testTypeId);
}

$tests = Test::where('case_id', $id)->orderBy('sensor')->get();
$sensors = Test::where('case_id', $id)->distinct('sensor')->pluck('sensor');

$marks = [];

foreach ($sensors as $sensor) {
    $pmin = 10000;
    $pmax = -999.99;
    $psens = 0;
    $pcount = 0;
    $TestSum = 0.0;
    $testSquareSum = 0.0;
    $variance = 0.0;
    $numerator = 0.0;
    $sd = 0.0;
    $testCount = Test::where('case_id', $id)->where('sensor', $sensor)->count();
    $arr = [];

    foreach ($tests as $test) {
        if (isset($test->testType) && $test->testType->id == $testTypeId) {
            if ($test->sensor == $sensor) {
                $pmin = min($pmin, (float)$test->temp + 100);
                $pmax = max($pmax, (float)$test->temp + 100);
                $psens += (float)$test->temp;
                $arr[$pcount] = $test->temp;
                $pcount++;
            }
        }
    }

    if ($pcount > 0) {
        $avg = round($psens / $pcount, 2);

        for ($i = 0; $i < $pcount; $i++) {
            $numerator += pow(($arr[$i] - $avg), 2);
        }

        $denominator = $testCount - 1;
        $sd = sqrt($numerator / $denominator);

        $y = (object)[
            'sensor' => $sensor,
            "min" => round($pmin - 100, 2),
            "max" => round($pmax - 100, 2),
            'avg' => $avg,
            'std' => round($sd, 2),
            'avg2' => $avg,
        ];

        if ($testType->is_humidity) {
            // Add humidity and temperature to the response
            $humidityTest = Test::where('case_id', $id)->where('sensor', $sensor)->where('test_type_id', 'your_humidity_test_type_id')->first();
            
            if ($humidityTest) {
                $y->humidity = $humidityTest->humidity;
                $y->temperature = $humidityTest->temperature;
            }
        }

        $marks[] = $y;
    }
}

return $marks;
 
        }
  
    // public function getTempWithFilter(Request $request, $id)
    // {

    //     $fields = Validator::make($request->all(), [
    //         'start_date' => 'required',
    //         'end_date' => 'required',
    //         'start_time' => 'required',
    //         'end_time' => 'required',
    //     ]);

    //     if ($fields->fails()) return response()->json(['errors' => $fields->errors()], 422);

    //     $tests = Test::where('case_id', $id)
    //         ->where('date', '>=', Carbon::parse($request->start_date)->format('Y-m-d'))
    //         ->where('time', '>=', Carbon::parse($request->start_time)->format('H:m'))
    //         ->where('date', '<=', Carbon::parse($request->end_date)->format('Y-m-d'))
    //         ->where('time', '<=', Carbon::parse($request->end_time)->format('H:m'))
    //         ->orderBy('sensor')
    //         ->get();
    //     $sensors = Test::where('case_id', $id)
    //         ->where('date', '>=', Carbon::parse($request->start_date)->format('Y-m-d'))
    //         ->where('time', '>=', Carbon::parse($request->start_time)->format('H:m'))
    //         ->where('date', '<=', Carbon::parse($request->end_date)->format('Y-m-d'))
    //         ->where('time', '<=', Carbon::parse($request->end_time)->format('H:m'))
    //         ->distinct('sensor')
    //         ->pluck('sensor');

    //     $c = Cases::where('id', $id)->where('type_of_room', 'Reefer Vehicle')->first();
    //     if ($c) {
    //         // return $c->test_types;
    //         $nmarks = [];
    //         $marks = [];
    //         foreach ($sensors as $sensor) {
    //             $pmin = 10000;
    //             $pmax = -999.99;
    //             $psens = 0;
    //             $pcount = 0;
    //             $nmin = 10000;
    //             $nmax = -999.99;
    //             $nsens = 0;
    //             $ncount = 0;
    //             $Testcount = 0;
    //             $TestSum = 0;
    //             $testSquareSum = 0;
    //             $variance = 0;
    //             foreach ($tests as $test) {
    //                 if (\strchr($test->testType->name, 'CONTINUOUS OPERATION')) {

    //                     // if(strchr($test->sensor,'AMB')) continue;

    //                     if ($test->sensor == $sensor) {
    //                         if ((float)$test->temp > 0) {
    //                             $pmin = min($pmin, (float)$test->temp + 100);
    //                             // $pmax = (float)$test->temp + 100;
    //                             $pmax = max($pmax, (float)$test->temp + 100);
    //                             $psens += (float)$test->temp;
    //                             $pcount++;
    //                             $TestSum += $test->temp;
    //                             $Testcount += 1;
    //                         } else {
    //                             $nmin = min($nmin, (float)$test->temp + 100);
    //                             $nmax = max($nmax, (float)$test->temp + 100);
    //                             $nsens += (float)$test->temp;
    //                             $ncount++;
    //                             $TestSum += $test->temp;
    //                             $Testcount += 1;
    //                         }

    //                         if ($TestSum > 0 && $Testcount > 0) {
    //                             $testAvg = $TestSum / $Testcount;
    //                             $testSquareSum += pow(($testAvg - $test->temp), 2);
    //                             $variance = $testSquareSum / $testAvg;
    //                         }
    //                     }
    //                 }
    //             }
    //             if ($pcount == 0) continue;
    //             else {
    //                 $y = (object)['sensor' => $sensor, "min" => $pmin - 100, "max" => $pmax - 100, 'avg' => $psens / $pcount, 'std' => sqrt($variance)];
    //                 $marks[] = $y;
    //             }

    //             if ($ncount == 0) continue;
    //             else {
    //                 $x = (object)['sensor' => $sensor, "min" => $nmin - 100, "max" => $nmax - 100, 'avg' => $nsens / $ncount, 'std' => sqrt($variance)];
    //                 $nmarks[] = $x;
    //             }
    //         }
    //         return response(['pos' => $marks, 'neg' => $nmarks], 200);
    //     }


    //     // check starts here
    //     $marks = [];
    //     foreach ($sensors as $sensor) {
    //         // return $sensor;
    //         $pmin = 10000;
    //         $pmax = -999.99;
    //         $psens = 0;
    //         $pcount = 0;
    //         // $Testcount = 0;
    //         $TestSum = 0.0;
    //         $testSquareSum = 0.0;
    //         $variance = 0.0;
    //         $numerator = 0.0;
    //         $sd = 0.0;
    //         $testCount = Test::where('case_id', $id)->where('sensor', $sensor)->count();
    //         $arr = [];
    //         foreach ($tests as $test) {
    //             if (isset($test->testType) && \strchr($test->testType->name, 'CONTINUOUS OPERATION')) {
    //                 // if (strchr($test->sensor, 'AMB')) continue;
    //                 // if ($test->sensor == $sensor) {
    //                 //     $pmin = min($pmin, (float)$test->temp + 100);
    //                 //     $pmax = max($pmax, (float)$test->temp + 100);
    //                 //     $psens += (float)$test->temp;
    //                 //     $pcount++;
    //                 //     $TestSum += $test->temp;
    //                 //     // $Testcount += 1;
    //                 // }

    //                 // if ($TestSum > 0) {
    //                 //     // $mean = $TestSum / count($tests); try 1
    //                 //     // $mean = $TestSum / $Testcount; try 2
    //                 //     $mean = $TestSum / $testCount; //try 3
    //                 //     $standardDeviation += pow(($test->temp - $mean), 2);
    //                 // }


    //                 if ($test->sensor == $sensor) {
    //                     $pmin = min($pmin, (float)$test->temp + 100);
    //                     $pmax = max($pmax, (float)$test->temp + 100);
    //                     $psens += (float)$test->temp;
    //                     $arr[$pcount] = $test->temp;
    //                     $pcount++;
    //                 }
    //             }
    //         }
    //         if ($pcount == 0) continue;
    //         else {
    //             $avg = round($psens / $pcount, 2);

    //             for ($i = 0; $i < $pcount; $i++) {
    //                 $numerator += pow(($arr[$i] - $avg), 2);
    //             }
    //             $denominator = $testCount - 1;
    //             $sd = sqrt($numerator / $denominator);


    //             $y = (object)['sensor' => $sensor, "min" => round($pmin - 100, 2), "max" => round($pmax - 100, 2), 'avg' => $avg, 'std' => round($sd, 2), 'avg2' => $avg];
    //             $marks[] = $y;
    //         }
    //     }
    //     return $marks;
    // }

    public function fetchRawData(Request $request, $caseId)
    {
        if ($request->has('test_type_id')) {

            // $sensors = Test::where('case_id', $caseId)->where('test_type_id', $request->test_type_id)->distinct('sensor')->pluck('sensor');
            // foreach ($sensors as $sensor) {
            //     $y = (object)['sensor' => $sensor, 'data' => Test::where('case_id', $caseId)->where('sensor', $sensor)->with('testType')->get()];
            //     $datas[] = $y;
            // }

            // if ($datas == 'Undefined')
            //     return response(['error' => "not found"], 404);
            // else
            //     return $datas;
            return Test::where('case_id', $caseId)->where('test_type_id', $request->test_type_id)->get();
        }

        return Test::where('case_id', $caseId)->get();
    }

    public function getRawDataWithFilter(request $request, $caseId)
    {

        $startDateTime = Carbon::parse($request->start_date . $request->start_time)->format('Y-m-d H:i:s');
        $endDateTime = Carbon::parse($request->end_date . $request->end_time)->format('Y-m-d H:i:s');

        if (count($request->sensors) > 0) {
            return FacadesDB::table('tests')
                ->where('case_id', $caseId)
                ->whereBetween('filter_datetime', [$startDateTime, $endDateTime])
                ->whereIn('sensor', $request->sensors)
                ->where('test_type_id', $request->test_type_id)
                ->get();
        }
        return FacadesDB::table('tests')
            ->where('case_id', $caseId)
            ->whereBetween('filter_datetime', [$startDateTime, $endDateTime])
            ->where('test_type_id', $request->test_type_id)
            ->get();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
            'case_id',
            'test_type_id',
            'date',
            'time',
            'temp',
            'sensor',
        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }
        return Test::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Test  $Test
     * @return \Illuminate\Http\Response
     */
  
    public function destroy($id)
    {
        return Test::find($id)->delete();
    }

    public function massDeleteAllOld(Request $request)
    {
        return Test::whereIn('id', $request->test_ids)->delete();
    }
  
  	public function massDeleteAll(Request $request)
	{
    $testIds = $request->test_ids;
    
    // Process IDs in smaller chunks
    collect($testIds)->chunk(1000)->each(function ($chunk) {
        Test::whereIn('id', $chunk)->delete();
    });

    return response()->json(['message' => 'Records deleted successfully']);
	}


    public function massUpdateAll(Request $request)
    {
        return Test::whereIn('id', $request->test_ids)->update([
            'test_type_id' => $request->test_type_id,
        ]);
    }

    public function replicateUpdateAll(Request $request)
    {
        $tests = Test::whereIn('id', $request->test_ids)->get();
        foreach ($tests as $test) {
            $newtest = $test->replicate();
            $newtest->test_type_id = $request->test_type_id;
            $newtest->save();
        }

        return response('success');
    }
}
