<?php

namespace App\Http\Controllers;

use App\Imports\SensorImport;
use App\Sensor;
use Illuminate\Http\Request;
use Rap2hpoutre\FastExcel\FastExcel;

class SensorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Sensor::latest()->get();
    }

    public function import(Request $request)
    {
        if ($request->hasFile('sheet')) {
            $file = $request->file('sheet');
            return (new FastExcel)->import($file, function ($row) {
                return Sensor::create($row);
            });

            return response('success');
        }
    }

    // public function import(Request $request)
    // {
    //     if ($request->file('sheet')) {
    //         $file = $request->file('sheet');
    //         $import = (new SensorImport)->import($file);
    //         // return $import;
    //         if ($import) {
    //             return response('success');
    //         } else {
    //             return response('failure');
    //         }
    //     }
    // }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $fileName = 'no_file.pdf';
        if ($request->hasFile('file')) {
            $fileName = $request->file('file')->hashName();
            $request->file('file')->move(storage_path('app/public/Sensorfiles/'), $fileName);
        }

        $Sensor = new Sensor();
        $Sensor->fill($request->except('file'));
        $Sensor->file = $fileName;
        $Sensor->save();
        return response()->json($Sensor);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Sensor  $Sensor
     * @return \Illuminate\Http\Response
     */
    public function show(Sensor $Sensor)
    {
        return response()->json($Sensor);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Sensor  $Sensor
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Sensor $Sensor)
    {
        if ($request->hasFile('file')) {
            $fileName = $request->file('file')->hashName();
            $request->file('file')->move(storage_path('app/public/Sensorfiles/'), $fileName);
            $Sensor->file = $fileName;
        }

        $Sensor->fill($request->except('file'));
        $Sensor->save();
        return response()->json($Sensor);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Sensor  $Sensor
     * @return \Illuminate\Http\Response
     */
    public function destroy(Sensor $Sensor)
    {
        return $Sensor->delete();
    }
}
