<?php

namespace App\Http\Controllers;

use App\Customer;
use App\Quotation;
use App\QuotationDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class QuotationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // return Quotation::with('user', 'customer', 'quotation_details', 'company')->paginate($request->pageSize);
        return Quotation::with('user', 'customer', 'quotation_details', 'company')->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
            'user_id' => 'required',
            'customer_id' => 'required',
            'company_id' => 'required',
            'products' => 'required',
        ], [], [
            'user_id' => 'User Name',
            'customer_id' => 'customer Name',
            'company_id' => 'company Name',
        ]);

        if ($val->fails()) return response()->json($val->errors());
        $Quotation = new Quotation;
        $Quotation->fill($request->all());
        $Quotation->save();

        $products = $request->products;
        foreach ($products as $product) {
            $detail = new QuotationDetail;
            $detail->fill($product);
            $detail->Quotation_id = $Quotation->id;
            $detail->save();
        }

        return response()->json(['created' => $Quotation], 201);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Quotation  $Quotation
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return Quotation::where('id', $id)->with('user', 'customer', 'Quotation_details', 'company')->first();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Quotation  $Quotation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
            'user_id' => 'required',
            'customer_id' => 'required',
            'company_id' => 'required',
            'products' => 'required',
        ], [], [
            'user_id' => 'User Name',
            'customer_id' => 'customer Name',
            'company_id' => 'company Name',
        ]);

        if ($val->fails()) return response()->json($val->errors());
        $Quotation = Quotation::find($id);
        $Quotation->update($request->all());
        $Quotation->save();

        if ($Quotation->is_approved == true) Customer::where('id', $request->customer_id)->update(['is_active' => 1]);

        $products = $request->products;
        foreach ($products as $product) {
            if (isset($product['id'])) {
                $detail = QuotationDetail::where('id', $product['id'])->first();
                $detail->update($product);
                $detail->Quotation_id = $Quotation->id;
                $detail->save();
            }
            if ($product['qty'] == 0) {
                $detail = QuotationDetail::where('id', $product['id'])->delete();
            }
            if (!isset($product['id'])) {
                $detail = new QuotationDetail;
                $detail->fill($product);
                $detail->Quotation_id = $Quotation->id;
                $detail->save();
            }
        }

        return response()->json(['updated' => $Quotation], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Quotation  $Quotation
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return Quotation::find($id)->delete();
    }
}
