<?php

namespace App\Http\Controllers;

use App\Invoice;
use App\InvoiceDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // return Invoice::with('user', 'customer', 'invoice_details', 'company')->paginate($request->pageSize);
         return Invoice::with('user', 'customer', 'invoice_details', 'company')->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
            'user_id' => 'required',
            'customer_id' => 'required',
            'company_id' => 'required',
            'products' => 'required',
        ], [], [
            'user_id' => 'User Name',
            'customer_id' => 'customer Name',
            'company_id' => 'company Name',
        ]);

        if ($val->fails()) return response()->json($val->errors());
        $invoice = new Invoice;
        $invoice->fill($request->all());
        $invoice->save();

        $products = $request->products;
        foreach ($products as $product) {
            $detail = new InvoiceDetail;
            $detail->fill($product);
            $detail->invoice_id = $invoice->id;
            $detail->save();
        }

        return response()->json(['created' => $invoice], 201);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return Invoice::where('id', $id)->with('user', 'customer', 'invoice_details', 'company')->first();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
            'user_id' => 'required',
            'customer_id' => 'required',
            'company_id' => 'required',
            'products' => 'required',
        ], [], [
            'user_id' => 'User Name',
            'customer_id' => 'customer Name',
            'company_id' => 'company Name',
        ]);

        if ($val->fails()) return response()->json($val->errors());
        $invoice = Invoice::find($id);
        $invoice->update($request->all());
        $invoice->save();

        $products = $request->products;
        foreach ($products as $product) {
            if (isset($product['id'])) {
                $detail = InvoiceDetail::where('id', $product['id'])->first();
                $detail->update($product);
                $detail->invoice_id = $invoice->id;
                $detail->save();
            }
            if ($product['qty'] == 0) {
                $detail = InvoiceDetail::where('id', $product['id'])->delete();
            }
            if (!isset($product['id'])) {
                $detail = new InvoiceDetail;
                $detail->fill($product);
                $detail->invoice_id = $invoice->id;
                $detail->save();
            }
        }

        return response()->json(['updated' => $invoice], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return Invoice::find($id)->delete();
    }
}
