<?php

namespace App\Http\Controllers;

use App\Cases;
use App\File;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class FileController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return File::all();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function store(Request $request)
    {
         $val = Validator::make($request->all(), [
            'case_id' => 'required',
            'user_id' => 'required',
        ]);

        $identityNo = Cases::where('id', $request->case_id)->first();

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        if ($request->hasFile('file_1')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_1')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_1')->getClientOriginalExtension();
            // Filename to store
            $file_1 = $filename . '_' . time() . '.' . $extension;
            // Upload file_1
            $path = $request->file('file_1')->storeAs("public/{$identityNo->identification_no}", $file_1);
        } else {
            $file_1 = 'no_file_1.pdf';
        }

        if ($request->hasFile('file_2')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_2')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_2')->getClientOriginalExtension();
            // Filename to store
            $file_2 = $filename . '_' . time() . '.' . $extension;
            // Upload file_2
            $path = $request->file('file_2')->storeAs("public/{$identityNo->identification_no}", $file_2);
        } else {
            $file_2 = 'no_file_2.pdf';
        }

        if ($request->hasFile('file_3')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_3')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_3')->getClientOriginalExtension();
            // Filename to store
            $file_3 = $filename . '_' . time() . '.' . $extension;
            // Upload file_3
            $path = $request->file('file_3')->storeAs("public/{$identityNo->identification_no}", $file_3);
        } else {
            $file_3 = 'no_file_3.pdf';
        }

        if ($request->hasFile('file_4')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_4')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_4')->getClientOriginalExtension();
            // Filename to store
            $file_4 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_4')->storeAs("public/{$identityNo->identification_no}", $file_4);
        } else {
            $file_4 = 'no_file_4.pdf';
        }
        
        if ($request->hasFile('file_5')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_5')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_5')->getClientOriginalExtension();
            // Filename to store
            $file_5 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_5')->storeAs("public/{$identityNo->identification_no}", $file_5);
        } else {
            $file_5 = 'no_file_5.pdf';
        }

        $file = new File;
        $file->user_id = $request->user_id;
        $file->case_id = $request->case_id;
        $file->file_1 = $file_1;
        $file->file_2 = $file_2;
        $file->file_3 = $file_3;
        $file->file_4 = $file_4;
        $file->file_5 = $file_5;
        $file->save();

        return $file;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    

    /**
     * Display the specified resource.
     *
     * @param  \App\File  $file
     * @return \Illuminate\Http\Response
     */
    public function show(File $file)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\File  $file
     * @return \Illuminate\Http\Response
     */
    public function edit(File $file)
    {
        //
    }
    
    public function update(Request $request,$id)
    {
        $val = Validator::make($request->all(), [
            'case_id' => 'required',
            'user_id' => 'required',
        ]);

        $identityNo = Cases::where('id', $request->case_id)->first();

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }
        
        $file=File::find($id);

        if ($request->hasFile('file_1')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_1')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_1')->getClientOriginalExtension();
            // Filename to store
            $file_1 = $filename . '_' . time() . '.' . $extension;
            // Upload file_1
            $path = $request->file('file_1')->storeAs("public/{$identityNo->identification_no}", $file_1);
            
            File::find($id)->update([
                'file_1'=>$file_1
                ]);
        } 

        if ($request->hasFile('file_2')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_2')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_2')->getClientOriginalExtension();
            // Filename to store
            $file_2 = $filename . '_' . time() . '.' . $extension;
            // Upload file_2
            $path = $request->file('file_2')->storeAs("public/{$identityNo->identification_no}", $file_2);
            
             File::find($id)->update([
                'file_2'=>$file_2
                ]);
        }

        if ($request->hasFile('file_3')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_3')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_3')->getClientOriginalExtension();
            // Filename to store
            $file_3 = $filename . '_' . time() . '.' . $extension;
            // Upload file_3
            $path = $request->file('file_3')->storeAs("public/{$identityNo->identification_no}", $file_3);
            
             File::find($id)->update([
                'file_3'=>$file_3
                ]);
        } 

        if ($request->hasFile('file_4')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_4')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_4')->getClientOriginalExtension();
            // Filename to store
            $file_4 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_4')->storeAs("public/{$identityNo->identification_no}", $file_4);
            
             File::find($id)->update([
                'file_4'=>$file_4
                ]);
        }
        
        if ($request->hasFile('file_5')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_5')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_5')->getClientOriginalExtension();
            // Filename to store
            $file_5 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_5')->storeAs("public/{$identityNo->identification_no}", $file_5);
            
             File::find($id)->update([
                'file_5'=>$file_5
                ]);
        }

        return $file;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\File  $file
     * @return \Illuminate\Http\Response
     */
   

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\File  $file
     * @return \Illuminate\Http\Response
     */
    public function destroy(File $file)
    {
        return File::find($id)->delete();
    }
}
