<?php

namespace App\Http\Controllers;

use App\DoorOpenType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DoorOpenTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return DoorOpenType::with('case')->get();
    }


    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
            'case_id',
            'door_open_test_name',

        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        return DoorOpenType::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DoorOpenType  $DoorOpenType
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return DoorOpenType::where('id', $id)->with('case')->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DoorOpenType  $DoorOpenType
     * @return \Illuminate\Http\Response
     */
    public function edit(DoorOpenType $DoorOpenType)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DoorOpenType  $DoorOpenType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
            'case_id',
            'door_open_test_name',
        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }
        return DoorOpenType::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DoorOpenType  $DoorOpenType
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return DoorOpenType::find($id)->delete();
    }
}
