<?php

namespace App\Http\Controllers;

use App\DataLoggerTwo;
use Illuminate\Http\Request;

class DataLoggerTwoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return DataLoggerTwo::get();
    }


    public function store(Request $request)
    {
        return DataLoggerTwo::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DataLoggerTwo  $DataLoggerTwo
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return DataLoggerTwo::where('id', $id)->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\DataLoggerTwo  $DataLoggerTwo
     * @return \Illuminate\Http\Response
     */
    public function edit(DataLoggerTwo $DataLoggerTwo)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DataLoggerTwo  $DataLoggerTwo
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return DataLoggerTwo::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DataLoggerTwo  $DataLoggerTwo
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return DataLoggerTwo::find($id)->delete();
    }
}
