<?php

namespace App\Http\Controllers;

use App\Cases;
use App\DataLogger;
use App\Imports\DataLoggerImport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Rap2hpoutre\FastExcel\FastExcel;


class DataLoggerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return DataLogger::with('case')->latest()->get();
    }

    public function uploadSheet(Request $request)
    {
        $fields = Validator::make($request->all(), [
            'sheet' => 'required|file'
        ]);

        if ($fields->fails()) return response()->json(['error' => $fields->errors()], 422);

        $sheet = $request->file('sheet');
        
        DataLogger::where('case_id', $request->case_id)->delete();

        $import = (new FastExcel)->import($sheet, function ($line) use ($request) {

            DataLogger::create([
                'case_id' => $request->case_id,
                'logger_id_no' => $line['logger_id_no'],
                'position' => $line['position'],
                'left_side_wall' => $line['left_side_wall'],
                'front_side_wall' => $line['front_side_wall'],
                'distance_from_ground' => $line['distance_from_ground'],
            ]);
        });
        // return $import;
        if ($import) {
            return response('success');
        } else {
            return response('failure');
        }
    }

    public function import(Request $request)
    {
        $file = $request->file('file');
        $import = (new DataLoggerImport)->import($file);
        // return $import;
        if ($import) {
            return response('success');
        } else {
            return response('failure');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        return DataLogger::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\DataLogger  $dataLogger
     * @return \Illuminate\Http\Response
     */
    public function show(Cases $cases)
    {
        return DataLogger::where('case_id', $cases->id)->get();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\DataLogger  $dataLogger
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, DataLogger $dataLogger)
    {
        return $dataLogger->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\DataLogger  $dataLogger
     * @return \Illuminate\Http\Response
     */
    public function destroy(DataLogger $dataLogger)
    {
        return $dataLogger->delete();
    }
}
