<?php

namespace App\Http\Controllers;

use App\CustomerDocument;
use Illuminate\Http\Request;

class CustomerDocumentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return CustomerDocument::with('customer')->latest()->get();
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
  /*  public function store(Request $request)
    {
        $cd = new CustomerDocument();

        $cd->fill($request->all());

        if ($request->hasFile('doc')) {
            $cd->doc = $request->file('doc')->hashName();
            $request->file('doc')->move(storage_path('app/public/CustomerDocuments/'), $cd->doc);
        }

        $cd->save();
        return $cd;
    }
	*/
  public function store(Request $request)
{
    // Validate the incoming request data if needed

    $cd = new CustomerDocument();

    // Fill the 'data' attribute with the request data
    $data = $request->all();

    // Handle multiple company_id values
    if ($request->has('company_id')) {
        $data['company_id'] = $request->input('company_id');
      
    }

    // Handle file upload if 'doc' file is present in the request
    if ($request->hasFile('doc')) {
        $docFileName = $request->file('doc')->hashName();
        $request->file('doc')->move(storage_path('app/public/CustomerDocuments/'), $docFileName);

        // Add 'doc' file name to the 'data' attribute
        $data['doc'] = $docFileName;
    }
		
    // Fill the model with the modified data
    $cd->fill($data);
  // dd($cd); 
    // Save the model
    $cd->save();

    // Return the saved model
    return $cd;
}

    /**
     * Display the specified resource.
     *
     * @param  \App\CustomerDocument  $customerDocument
     * @return \Illuminate\Http\Response
     */
    public function show(CustomerDocument $customerDocument)
    {
        return CustomerDocument::find($customerDocument->id)->with('customer', 'company')->latest()->get();
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CustomerDocument  $customerDocument
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CustomerDocument $customerDocument)
    {
        if ($request->hasFile('doc')) {
            $customerDocument->doc = $request->file('doc')->hashName();
            $request->file('doc')->move(storage_path('app/public/CustomerDocuments/'), $customerDocument->doc);
        }

        $customerDocument->update($request->except('doc'));
        return $customerDocument;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CustomerDocument  $customerDocument
     * @return \Illuminate\Http\Response
     */
    public function destroy(CustomerDocument $customerDocument)
    {
        return $customerDocument->delete();
    }
}
