<?php

namespace App\Http\Controllers;

use App\Customer;
use App\Company;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Customer::with('company', 'documents')->get();
    }


    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
            'name' => 'required', 'email' => 'required', 'password' => 'required', 'role' => 'required', 'type', 'emp_id', 'is_active', 'phone' => 'required', 'gst_no', 'pan_no', 'location', 'pincode'

        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        $cust = Customer::create($request->all());
        $cust->password = Hash::make($request->newPassword);
        $cust->save();
        return $cust;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Customer  $Customer
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return Customer::where('id', $id)->with('company', 'documents')->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Customer  $Customer
     * @return \Illuminate\Http\Response
     */
    public function edit(Customer $Customer)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Customer  $Customer
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
            'name' => 'required', 'email' => 'required', 'role' => 'required', 'type', 'emp_id', 'is_active', 'phone' => 'required', 'gst_no', 'pan_no', 'location', 'pincode'
        ]);
        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }
        $user = Customer::find($id)->update($request->all());

        if ($request->has('password')) {
            $user = Customer::find($id);
            $user->password = Hash::make($request->password);
            $user->save();
            return $user;
        }
        return $user;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Customer  $Customer
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return Customer::find($id)->delete();
    }
}
