<?php

namespace App\Http\Controllers;

use App\Company;
use App\CompanyAddress;
use App\CompanyFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Company::with('customers', 'caseDetails', 'addresses', 'files')->get();
    }


    public function store(Request $request)
    {
        // if ($request->hasFile('file')) {
        //     // Get filename with the extension
        //     $filenameWithExt = $request->file('file')->getClientOriginalName();
        //     // Get just filename
        //     $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //     // Get just ext
        //     $extension = $request->file('file')->getClientOriginalExtension();
        //     // Filename to store
        //     $fileNameToStore = $filename . '_' . time() . '.' . $extension;
        //     // Upload file
        //     $path = $request->file('file')->storeAs('public/companies', $fileNameToStore);
        // } else {
        //     $fileNameToStore = 'no_file.pdf';
        // }
        $c = Company::create($request->all());

        if ($request->has('addresses')) {

            foreach (json_decode($request->addresses,true) as $address) {
                $ca = CompanyAddress::create($address);
                $ca->company_id = $c->id;
                $ca->save();
            }
        }

        if ($request->hasFile('files')) {
            foreach ($request->file('files') as $file) {
                // save to server disk
                $filenameWithExt = $file->getClientOriginalName();
                $file->move(\storage_path('app/public/CompanyFiles'), $filenameWithExt);

                // save to db
                $cf = new CompanyFile();
                $cf->file = $filenameWithExt;
                $cf->company_id = $c->id;
                $cf->save();
            }
        }


        return $c;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Company  $Company
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return Company::where('id', $id)->with('customers', 'caseDetails')->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Company  $Company
     * @return \Illuminate\Http\Response
     */
    public function edit(Company $Company)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Company  $Company
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // if ($request->hasFile('file')) {
        //     // Get filename with the extension
        //     $filenameWithExt = $request->file('file')->getClientOriginalName();
        //     // Get just filename
        //     $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        //     // Get just ext
        //     $extension = $request->file('file')->getClientOriginalExtension();
        //     // Filename to store
        //     $fileNameToStore = $filename . '_' . time() . '.' . $extension;
        //     // Upload file
        //     $path = $request->file('file')->storeAs('public/companies', $fileNameToStore);
        //     Company::find($id)->update(['file' => $fileNameToStore]);
        // }


        // $c = DB::transaction(function (Request $request) use ($id) {

            $c = Company::find($id)->update($request->all());

            if ($request->has('addresses')) {
                foreach (json_decode($request->addresses,true) as $address) {
                    if (isset($address['id'])) {
                        CompanyAddress::find($address['id'])->update($address);
                    } 
                    if(isset($address['id']) && $address['location']===0){
                        CompanyAddress::find($address['id'])->delete();
                        continue;
                    }
                    if(!isset($address['id']))
                    {
                        $ca = CompanyAddress::create($address);
                        $ca->company_id = $id;
                        $ca->save();
                    }
                }
            }

       

        return $c;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Company  $Company
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return Company::find($id)->delete();
    }
}
