<?php

namespace App\Http\Controllers;

use App\ColRow;
use Illuminate\Http\Request;

class ColRowController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return ColRow::with('col')->get();
    }


    public function store(Request $request)
    {
        return ColRow::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\ColRow  $ColRow
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return ColRow::where('id', $id)->with('col')->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\ColRow  $ColRow
     * @return \Illuminate\Http\Response
     */
    public function edit(ColRow $ColRow)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\ColRow  $ColRow
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return ColRow::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\ColRow  $ColRow
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return ColRow::find($id)->delete();
    }
}
