<?php

namespace App\Http\Controllers;

use App\Col;
use Illuminate\Http\Request;

class ColController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Col::with('colrows')->get();
    }


    public function store(Request $request)
    {
        return Col::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Col  $Col
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return Col::where('id', $id)->with('colrows')->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Col  $Col
     * @return \Illuminate\Http\Response
     */
    public function edit(Col $Col)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Col  $Col
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return Col::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Col  $Col
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return Col::find($id)->delete();
    }
}
