<?php

namespace App\Http\Controllers;

use App\CasesImage;
use Illuminate\Auth\Events\Validated;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CasesImageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $vaildator = Validator::make($request->all(), [
            'file' => 'required',
            'case_id' => 'required'
        ]);

        if ($vaildator->fails()) return \response(['errors' => $vaildator->errors()->getMessages()], 422);

        if ($request->has('id')) {
            $fileNameWithExt = $request->file('file')->getClientOriginalName();
            $request->file('file')->move(\storage_path('app/public/Cases-Files/'), $fileNameWithExt);
            $ci = CasesImage::find($request->id);
            $ci->fill($request->all());
            $ci->file = $fileNameWithExt;
            $ci->save();
            return $ci;
        }


        if ($request->hasFile('file')) {
            $fileNameWithExt = $request->file('file')->getClientOriginalName();
            $request->file('file')->move(\storage_path('app/public/Cases-Files/'), $fileNameWithExt);
            $ci = new CasesImage();
            $ci->fill($request->all());
            $ci->file = $fileNameWithExt;
            $ci->save();
        }

        return $ci;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\CasesImage  $casesImage
     * @return \Illuminate\Http\Response
     */
    public function show(CasesImage $casesImage)
    {
        return $casesImage;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\CasesImage  $casesImage
     * @return \Illuminate\Http\Response
     */
    public function edit(CasesImage $casesImage)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\CasesImage  $casesImage
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, CasesImage $casesImage)
    {
        $vaildator = Validator::make($request->all(), [
            'file' => 'required',
            'case_id' => 'required'
        ]);

        if ($vaildator->fails()) return \response(['errors' => $vaildator->errors()->getMessages()], 422);

        if ($request->hasFile('file')) {
            $fileNameWithExt = $request->file('file')->getClientOriginalName();
            $casesImage->fill($request->all());
            $casesImage->file = $fileNameWithExt;
            $casesImage->save();
        }

        return $casesImage;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\CasesImage  $casesImage
     * @return \Illuminate\Http\Response
     */
    public function destroy(CasesImage $casesImage)
    {
        return $casesImage->delete();
    }
}
