<?php

namespace App\Http\Controllers;

use App\CaseDetail;
use App\Cases;
use App\User;
use App\Test;
use App\Customer;
use App\PageDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;

class CasesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      $cases = Cases::with('user', 'company', 'customer', 'doorTypeTest', 'files', 'address', 'acDetail', 'pageDetails')->get();
      foreach($cases as $case){
        $case->extras = json_decode($case->extras);
      }
      return $cases;
    }

    public function getSensor($caseId)
    {
        return DB::select(' select * from `tests` WHERE `tests`.`case_id`=\'' . $caseId . '\' GROUP by `tests`.`sensor` HAVING count(`sensor`) > 0');
    }


    public function store(Request $request)
    {
        $val = Validator::make($request->all(), [
            'user_id' => 'required',
            'company_id' => 'required',
            'type_of_room',
            'type_of_cycle',
            'operating_range',
            'load_status',
            'CCT_Recording_Interval',
            'Recovery_Recording_Interval',
            'unit_of_dimension',
            'unit_of_volume',
            'usage_area',
            'type_ac_unit',
            'total_installed_cooling_capacity',
            'capacity',
            'unit',
          'performedOnDate'
        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        if ($request->hasFile('file_1')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_1')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_1')->getClientOriginalExtension();
            // Filename to store
            $file_1 = $filename . '_' . time() . '.' . $extension;
            // Upload file_1
            $path = $request->file('file_1')->storeAs("public/{$request->identification_no}", $file_1);
        } else {
            $file_1 = 'no_file_1.pdf';
        }

        if ($request->hasFile('file_2')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_2')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_2')->getClientOriginalExtension();
            // Filename to store
            $file_2 = $filename . '_' . time() . '.' . $extension;
            // Upload file_2
            $path = $request->file('file_2')->storeAs("public/{$request->identification_no}", $file_2);
        } else {
            $file_2 = 'no_file_2.pdf';
        }

        if ($request->hasFile('file_3')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_3')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_3')->getClientOriginalExtension();
            // Filename to store
            $file_3 = $filename . '_' . time() . '.' . $extension;
            // Upload file_3
            $path = $request->file('file_3')->storeAs("public/{$request->identification_no}", $file_3);
        } else {
            $file_3 = 'no_file_3.pdf';
        }

        if ($request->hasFile('file_4')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_4')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_4')->getClientOriginalExtension();
            // Filename to store
            $file_4 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_4')->storeAs("public/{$request->identification_no}", $file_4);
        } else {
            $file_4 = 'no_file_4.pdf';
        }

        if ($request->hasFile('file_5')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_5')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_5')->getClientOriginalExtension();
            // Filename to store
            $file_5 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_5')->storeAs("public/{$request->identification_no}", $file_5);
        } else {
            $file_5 = 'no_file_5.pdf';
        }

        if ($request->hasFile('file_6')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_6')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_6')->getClientOriginalExtension();
            // Filename to store
            $file_6 = $filename . '_' . time() . '.' . $extension;
            // file_6 file_4
            $path = $request->file('file_6')->storeAs("public/{$request->identification_no}", $file_6);
        } else {
            $file_6 = 'no_file_6.pdf';
        }

        $case = Cases::create($request->all());
        $case->file_1 = $file_1;
        $case->file_2 = $file_2;
        $case->file_3 = $file_3;
        $case->file_4 = $file_4;
        $case->file_5 = $file_5;
        $case->file_6 = $file_6;
        $case->created_date = \Carbon\Carbon::today()->toDateString();
        // $case->prepared_by_time = now();
        $case->save();


        CaseDetail::create([
            'user_id' => $request->user_id,
            'company_id' => $request->company_id,
            'case_id' => $case->id,
            'completed_status' => 0
        ]);

        PageDetail::create([
            'case_id' => $case->id,
            'continuous_cycle_1' => 0,
            'continuous_cycle_2' => 0,
            'continuous_cycle_3' => 0,
            'door_cycle_1' => 0,
            'door_cycle_2' => 0,
            'door_cycle_3' => 0,
            'static_cycle_1' => 0,
            'static_cycle_2' => 0,
            'static_cycle_3' => 0,
            'power_cycle_1' => 0,
            'power_cycle_2' => 0,
            'power_cycle_3' => 0,
            'ac' => 0,
            'risk' => 0,
            'remark' => 0,
        ]);

        return $case;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Cases  $cases
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
      $cases = Cases::where('id', $id)->with('user', 'company', 'customer', 'doorTypeTest', 'caseDetails.user', 'caseDetails.customer', 'files', 'address', 'acDetail', 'pageDetails')->first();

      $cases->extras = json_decode($cases->extras);
      return $cases;
    }

    public function stats()
    {
        $user = Auth::user();
        if ($user->role == "supervisor") {
            $comp = Cases::where('approved_status', 1)->where('user_id', $user->id)->get()->count();
            $Incomp = Cases::where('approved_status', 0)->where('user_id', $user->id)->get()->count();
            $total = Cases::where('user_id', $user->id)->count();
            return response(['comp' => $comp, 'inComp' => $Incomp, 'total' => $total], 200);
        }
        $comp = Cases::where('approved_status', 1)->get()->count();
        $Incomp = Cases::where('approved_status', 0)->get()->count();
        $total = Cases::count();
        $todayCase = Cases::whereDate('created_at', \Carbon\Carbon::today()->toDateString())->count();
        return response(['comp' => $comp, 'inComp' => $Incomp, 'total' => $total, 'todayCase' => $todayCase], 200);
    }

    public function dailycase()
    {
        // $dates=Cases::pluck('created_date');
        return DB::table('cases')->select(DB::raw('COUNT(cases.id) as count'), 'cases.created_date')->groupBy('created_date')->get();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Cases  $cases
     * @return \Illuminate\Http\Responseif()
     */
    public function passCase(Request $request)
    {
        $caseid = $request->case_id;
        if ($request->user_id) {
            $user = User::where('id', $request->user_id)->first();
            $caseDetail = CaseDetail::where('case_id', $caseid)->first();
            $caseDetail->completed_status = 1;
            $caseDetail->save();

            Cases::where('id', $caseid)->where('sent_for_checking_status', 0)->update(['sent_for_checking_status' => 1, 'prepared_by_time' => now(), 'prepared_by' => auth()->user()->name]);
            $case = Cases::find($caseid);


            return CaseDetail::create([
                'user_id' => $user->id,
                'customer_id' => $caseDetail->customer_id,
                'company_id' => $caseDetail->company_id,
                'case_id' => $caseid,
                'completed_status' => 0
            ]);
        } else if ($request->customer_id) {

            $customer = Customer::where('id', $request->customer_id)->first();

            $caseDetail = CaseDetail::where('case_id', $caseid)->first();
            $caseDetail->completed_status = 1;
            $caseDetail->save();

            if (Cases::where('id', $caseid)->where('sent_for_approval_status', 0)->first()) {
                $user = Auth::user();
                Cases::where('id', $caseid)->where('sent_for_approval_status', 0)->update(['sent_for_approval_status' => 1, 'checked_by_time' => now(), 'checked_by' => $user->name]);
                return CaseDetail::create([
                    'user_id' => $caseDetail->user_id,
                    'customer_id' => $user->id,
                    'case_id' => $caseid,
                    'completed_status' => 0
                ]);
            }
            // dd(auth()->user());
            // dd(Cases::where('id', $caseid)->whereNull('reviewed_by_time')->first());

            if (Cases::where('id', $caseid)->where('approved_by', '=', null)->where('approved_status', 0)->first() && auth()->user()->role == 'owner') {

                Cases::where('id', $caseid)->where('approved_by', '=', null)->first()->update(
                    [
                        'approved_by' => auth()->user()->name,
                        'approved_by_time' => now()
                    ]
                );
            } else if (Cases::where('id', $caseid)->whereNull('reviewed_by_time')->first() && auth()->user()->role == 'staff') {

                Cases::where('id', $caseid)->where('reviewed_by', '=', null)->first()->update(
                    [
                        'reviewed_by' => auth()->user()->name,
                        'reviewed_by_time' => now()
                    ]
                );
            } else {
                return response(['msg' => "case is already been approved"]);
            }

            return CaseDetail::create([
                'user_id' => $caseDetail->user_id,
                'customer_id' => $request->customer_id,
                'case_id' => $caseid,
                'completed_status' => 0
            ]);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Cases  $cases
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $val = Validator::make($request->all(), [
            // 'user_id' => 'required',
            // 'customer_id' => 'required',
            // 'bill_report_type_id' => 'required',
            'type_of_room',
            'type_of_cycle',
            'operating_range',
            'load_status',
            'CCT_Recording_Interval',
            'Recovery_Recording_Interval',
            'unit_of_dimension',
            'unit_of_volume',
            'usage_area',
            'type_ac_unit',
            'total_installed_cooling_capacity',
            'capacity',
            'unit',
          'performedOnDate',
        ]);

        if ($val->fails()) {
            return response(['error' => $val->errors()], 400);
        }

        Cases::find($id)->update($request->all());

        $case = Cases::find($id);

        if ($request->hasFile('file_1')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_1')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_1')->getClientOriginalExtension();
            // Filename to store
            $file_1 = $filename . '_' . time() . '.' . $extension;
            // Upload file_1
            $path = $request->file('file_1')->storeAs("public/{$case->identification_no}", $file_1);

            $case->update(['file_1' => $file_1]);
        }

        if ($request->hasFile('file_2')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_2')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_2')->getClientOriginalExtension();
            // Filename to store
            $file_2 = $filename . '_' . time() . '.' . $extension;
            // Upload file_2
            $path = $request->file('file_2')->storeAs("public/{$case->identification_no}", $file_2);

            $case->update(['file_2' => $file_2]);
        }

        if ($request->hasFile('file_3')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_3')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_3')->getClientOriginalExtension();
            // Filename to store
            $file_3 = $filename . '_' . time() . '.' . $extension;
            // Upload file_3
            $path = $request->file('file_3')->storeAs("public/{$case->identification_no}", $file_3);

            $case->update(['file_3' => $file_3]);
        }

        if ($request->hasFile('file_4')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_4')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_4')->getClientOriginalExtension();
            // Filename to store
            $file_4 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_4')->storeAs("public/{$case->identification_no}", $file_4);

            $case->update(['file_4' => $file_4]);
        }

        if ($request->hasFile('file_5')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_5')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_5')->getClientOriginalExtension();
            // Filename to store
            $file_5 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_5')->storeAs("public/{$case->identification_no}", $file_5);

            $case->update(['file_5' => $file_5]);
        }

        if ($request->hasFile('file_6')) {
            // Get filename with the extension
            $filenameWithExt = $request->file('file_6')->getClientOriginalName();
            // Get just filename
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            // Get just ext
            $extension = $request->file('file_6')->getClientOriginalExtension();
            // Filename to store
            $file_6 = $filename . '_' . time() . '.' . $extension;
            // Upload file_4
            $path = $request->file('file_6')->storeAs("public/{$case->identification_no}", $file_6);

            $case->update(['file_6' => $file_6]);
        }
        return $case;
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Cases  $cases
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return Cases::find($id)->delete();
    }
}
