<?php

namespace App\Http\Controllers;

use App\BillReportType;
use Illuminate\Http\Request;

class BillReportTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return BillReportType::get();
    }


    public function store(Request $request)
    {
        return BillReportType::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\BillReportType  $BillReportType
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return BillReportType::where('id', $id)->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\BillReportType  $BillReportType
     * @return \Illuminate\Http\Response
     */
    public function edit(BillReportType $BillReportType)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\BillReportType  $BillReportType
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return BillReportType::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\BillReportType  $BillReportType
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return BillReportType::find($id)->delete();
    }
}
