<?php

namespace App\Http\Controllers;

use App\Bill;
use Illuminate\Http\Request;

class BillController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return Bill::get();
    }


    public function store(Request $request)
    {
        return Bill::create($request->all());
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Bill  $Bill
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        return Bill::where('id', $id)->first();
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Bill  $Bill
     * @return \Illuminate\Http\Response
     */
    public function edit(Bill $Bill)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Bill  $Bill
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        return Bill::find($id)->update($request->all());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Bill  $Bill
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        return Bill::find($id)->delete();
    }
}
