<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class DoorOpenType extends Model
{
    protected $fillable = [
        'case_id',
        'do_off_time',
        'set_limit_cross_out_time',
        'dcp_on_time',
        'set_limit_cross_in_time',
        'excursion',
        'recovery',
        'door_open_test_name',
        'set_temp',
        'start_date',
        'end_date',
        'x_min_excersion',
        'x_max_excersion',
        'y_min_excersion',
        'y_max_excersion',
        'x_min_recovery',
        'x_max_recovery',
        'y_min_recovery',
        'y_max_recovery',
    ];

    public function case()
    {
        return $this->belongsTo('App\Cases', 'case_id', 'id');
    }
}
