<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Customer extends Authenticatable
{
    use HasApiTokens, Notifiable;

    protected $table = 'customers';

    protected $fillable = [
        'name', 'email', 'password', 'role', 'type', 'emp_id', 'is_active', 
        'phone', 'gst_no', 'pan_no', 'address', 'location', 'pincode', 'company_id'
    ];

    protected $hidden = [
        'password', 'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function company()
    {
        return $this->belongsTo(\App\Company::class, 'company_id');
    }

    public function documents()
    {
        return $this->hasMany(\App\CustomerDocument::class);
    }
}
