<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
     protected $table = 'companies';
    protected $fillable = [
        'name', 'address', 'pincode', 'is_active', 'phone', 'location', 'pan_no',
        'gstin', 'rtgs', 'neft', 'bank', 'branch', 'beneficiary', 'current_ac', 'ifsc_code', 'internal', 'file'
    ];

    public function addresses()
    {
        return $this->hasMany(CompanyAddress::class);
    }

    public function files()
    {
        return $this->hasMany(CompanyFile::class);
    }

    public function customers()
    {
        return $this->hasMany('App\Customer');
    }

    public function caseDetails()
    {
        return $this->hasMany('App\CaseDetail');
    }
}
