<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Cases extends Model
{
    protected $fillable = [
        'user_id',
        'company_id',
        'customer_id',
        'bill_report_type_id',
        'type_of_room',
        'type_of_cycle',
        'identification_no',
        'report_no',
        'min_operating_range',
        'max_operating_range',
        'set_point',
        'load_status',
        'no_of_loggers',
        'mapping_start_date',
        'mapping_end_date',
        'next_due_date',
        'no_of_cycles',
        'continuous_cycle_start_date',
        'continuous_cycle_end_date',
        'CCT_Recording_Interval',
        'Recovery_Recording_Interval',
        'Door_Open_Test_1_start_date',
        'Door_Open_Test_1_end_date',
        'Door_Open_Test_2_start_date',
        'Door_Open_Test_2_end_date',
        'Door_Open_Test_3_start_date',
        'Door_Open_Test_3_end_date',
        'power_failure_start_date',
        'power_failure_end_date',
        'unit_of_dimension',
        'unit_of_volume',
        'length',
        'width',
        'height',
        'volume',
        'cfa',
        'model_no',
        'period',
        'usage_area',
        'type_ac_unit',
        'total_installed_cooling_capacity',
        'capacity',
        'unit',
        'hot_spot',
        'cold_spot',
        'total_no_of_cooling_units_installed_no_of_blowers',
        'type_of_switching_standby',
        'reviewed_by',
        'approved_by',
        'prepared_by',
        'checked_by',
        'sent_for_approval_status',
        'approved_status',
        'sent_for_checking_status',
        'checked_status',
        'reopen_status',
        'details_of_master_instrument',
        'obeservation_remark',
        'concluding_remark',
        'conclusion',
        'calibration_certificate_no',
        'file_1',
        'file_2',
        'file_3',
        'file_4',
        'file_5',
        'vehicle_make',
        'vehicle_model',
        'vehicle_chasis',
        'ac_make',
        'ac_serial_num',
        'ac_model',
        'vehicle_type',
        'file_6',
        'min_operating_range1',
        'max_operating_range1',
        'created_date',
         'cycle',
        'mkt',
      	'is_humidity',
        'pos1',
        'pos2','mkt2','company_address_id', 'reviewed_by_time',
        'approved_by_time',
        'checked_by_time',
        'prepared_by_time','extras','max_operating_range2','min_operating_range2','performedOnDate'

    ];	
  
  	protected $casts = [ 'extras' => 'array' ];

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function customer()
    {
        return $this->belongsTo('App\Customer');
    }
    
    public function company()
    {
        return $this->belongsTo('App\Company');
    }
    
    public function doorTypeTest()
    {
        return $this->hasMany('App\DoorOpenType','case_id','id');
    }

    public function billReportType()
    {
        return $this->belongsTo('App\BillReportType');
    }

    public function caseDetails()
    {
        return $this->hasMany('App\CaseDetail','case_id');
    }

    public function bill()
    {
        return $this->hasOne('App\Bill', 'case_id', 'id');
    }
    
    public function files()
    {
        return $this->hasMany(CasesImage::class,'case_id');
    }
    
    public function tests()
    {
        return $this->hasMany(Test::class,'case_id')->distinct('sensor');
    }
    
    public function address()
    {
        return $this->belongsTo(CompanyAddress::class,'company_address_id');
    }
    
    public function pageDetails()
    {
        return $this->hasOne(PageDetail::class, 'case_id');
    }
    
    public function acDetail()
    {
        return $this->hasOne(ACDetail::class);
    }
}
