<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Bill extends Model
{
    protected $fillable = [
        'case_id',
        'initial_charges',
        'additional_charges',
        'total_charges',
        'gst',
        'final_amount',
        'paid_status',
        'partial_paid_status',
    ];

    public function cases()
    {
        return $this->belongsTo('App\Cases', 'case_id', 'id');
    }
}
